#!/bin/sh

clear

ARQ=$(uname -m)
if test "$ARQ" = "x86_64"  
then
  BITS=64
else
  BITS=32
fi

DISTRO=""
if [ -e "/etc/SuSE-release" ];
then
  #SuSE
  DISTRO="SuSE"
else
  if [ -e "/etc/redhat-release" ];
  then
    #RedHat / CentOS
    DISTRO="RedHat"
    DESC_DISTRO=$(cat /etc/redhat-release)
  else
    if [ -e "/etc/lsb-release" ]; 
    then
       id=$(egrep 'DISTRIB_ID=' /etc/lsb-release)
       DISTRO=${id##DISTRIB_ID=}
    else
       if [ -e "/etc/debian_version" ]; 
       then
	  VERSION=$(cat /etc/debian_version | awk '{ print(substr($0, 0, 4)) }')
          if test "$VERSION" = "5.0"
          then 
   	       DISTRO="Debian"
          else
   	       DISTRO="DebianSqueeze"
          fi
       fi
     fi
  fi
fi

docker=0
if [ "$1" = "--docker" ]; then
   docker=1
fi
if [ "$2" = "--docker" ]; then
   docker=1
fi

case $DISTRO in
    SuSE   )
	echo "Iniciando instalación en $DISTRO $BITS"
	./install_backoffice_suse.sh
        ;;
    Ubuntu )
	echo "Iniciando instalación en $DISTRO $BITS"
	./install_backoffice_ubuntu.sh
        ;;
    Debian )
	echo "Iniciando instalación en $DISTRO $BITS"
	./install_backoffice_debian_lenny.sh
        ;;
    DebianSqueeze )
	echo "Iniciando instalación en Debian $VERSION $BITS"
	./install_backoffice_debian.sh "$1" "$2"

	if test $? -eq 0; then
           echo "Instalación básica completada correctamente. Continuando con el resto del proceso de instalación"
        else
	   echo ""
           echo "========================================================================="
           echo "ERROR EN LA INSTALACIÓN BÁSICA. DEBES SOLUCIONAR LOS PROBLEMAS DETECTADOS"
           echo "Y REINICIAR EL PROCESO DE INSTALACIÓN PARA PODER CONTINUAR."
           echo "========================================================================="
	   exit 1
        fi
        ;;
    RedHat )
	echo "Iniciando instalación en $DISTRO $BITS"
        ./install_backoffice_redhat.sh
        ;;
esac

# INSTALAMOS ZEND, DEPENDIENDO DE LA ARQUITECTURA LA VERSIÓN DE 32 O 64 BITS
#echo "Instalación de Zend Optimizer"
mkdir /usr/local/Zend

if [ $BITS = 64 ];
then
	cp ./Zend_64/* /usr/local/Zend -R
else
        cp ./Zend/* /usr/local/Zend -R
fi

chmod a+rw /usr/local/Zend -R

# Instalamos Ioncube
#cp ./20ioncube.ini /etc/php5/apache2/conf.d/20ioncube.ini
#if [ $BITS = 64 ];
#then
#       cp ./ioncube/oncube_loaders_lin_x86-64/*.so /usr/lib/php5/20090626+lfs/
#else
#        cp ./ioncube/oncube_loaders_lin_x86/*.so /usr/lib/php5/20090626+lfs/
#fi

if [ $docker -eq 1 ]; then
  echo "Instalación en Docker. No se reinician los servicios"
else
  echo ""
  echo "Reiniciando Apache"
  /etc/init.d/apache2 restart

  echo ""
  echo "Iniciando NetOffice"
  /etc/init.d/netoffice start
fi

echo ""
echo ""
echo "INSTALACIÓN FINALIZADA."
echo ""
echo "Recuerta también que no puedes importar directamente una base de datos"
echo "desde un servidor Windows si está en formato InnoDB; en este caso, en "
echo "el servidor Windows, deberás ejecutar:"
echo " mysqldump --single-transaction --quick --no-autocommit ViewOffice > c:\ViewOffice.sql"
echo ""
echo "En este servidor podrás importarla:"
echo " mysql --user=root ViewOffice < ViewOffice.sql"


