#!/bin/bash
clear
LOG=./log
echo "" > $LOG
fecha=$(date +%d-%m-%y_%H_%M_%S | cut -d"_" -f 1-3)
fecha_completa=$date
ruta_backup=$PWD/backup_config_files
mysql_pass=""
phpversion=5

silent=0
docker=0
if [ "$1" = "--silent" ]; then
   silent=1
fi
if [ "$2" = "--silent" ]; then
   silent=1
fi
if [ "$1" = "--docker" ]; then
   docker=1
fi
if [ "$2" = "--docker" ]; then
   docker=1
fi

#
# DEFINICIÓN DE FUNCIONES
#
log_msg()
(
	echo $($1) $2
	echo $($1) $2 >> $LOG
)

exitCode()
(
	if test $1 -eq 100;
	then
		log_msg echo "---------------------------------------------------"
		log_msg echo "ERROR DESCARGANDO PAQUETES: Código devuelto: $1"
		log_msg echo "NO SE PUEDE CONTINUAR CON EL PROCESO DE INSTALACIÓN"
		log_msg echo "---------------------------------------------------"
		return 1
	fi
	
	if test $1 -eq 0;
	then
		log_msg echo "Operación completada correctamente."
	else
		log_msg echo "--------------------------"
		log_msg echo "ERROR: Código devuelto: $1"
		log_msg echo "--------------------------"
		return 1
	fi

	return 0
)

ask() {
	while true; do
		if [ "${2:-}" = "S" ]; then
			prompt="S/n"
			default=S
		elif [ "${2:-}" = "N" ]; then
			prompt="s/N"
			default=N
		else
			prompt="s/n"
			default=
		fi
		# Ask the question (not using "read -p" as it uses stderr not stdout)
		echo -n "$1 [$prompt] "
		if [ $silent -eq 1 ]; then
			REPLY=$default
		else
			# Read the answer (use /dev/tty in case stdin is redirected from somewhere else)
			read REPLY </dev/tty
		fi

		# Default?
		if [ -z "$REPLY" ]; then
			REPLY=$default
		fi
		# Check if the reply is valid
		case "$REPLY" in
			S*|s*) return 0 ;;
			N*|n*) return 1 ;;
		esac
	done
}

common1()
{
	log_msg echo ""
	log_msg echo ""
	log_msg echo "INSTALACIÓN DE BACKOFFICE"
	echo ""
	echo "RECUERDA QUE TIENES QUE EJECUTAR ESTE SCRIPT COMO 'root'."
	echo "SI NO LO HAS EJECUTADO COMO ROOT, ENCONTRARÁS ERRORES DE PERMISOS."
	echo " su root"
	echo " ./install_backoffice.sh"
	echo ""
	echo "ESTE SCRIPT DE INSTALACIÓN INSTALARÁ:"
	echo ""
	log_msg echo ""
	log_msg echo "Iniciando instalación en fecha $fecha_completa"
}
common2()
{
	echo " - Una base de datos de ejemplo"
	echo ""
	echo "EJECUTA TAMBIÉN"
	echo " ./activar_vnc_debian.sh"
	echo "PARA ACTIVAR EL ACCESO POR VNC AL SERVIDOR"
	echo ""
	echo ""
	
	log_msg echo "¿Quieres que se usen los archivos de configuración de Apache, PHP y MySQL personalizados?"
	if ask "Ésto SIEMPRE es recomendable para instalaciones estándar. " "S";then
		echo "IMPORTANTE: Si algo va mal, podrás recuperar los archivos de configuración originales de la siguiente ruta: $ruta_backup"
		log_msg echo "Has elegido usar los archivos personalizados"
		conffiles="s"
	else
		log_msg echo "Has elegido usar los archivos por defecto"
		conffiles="n"
	fi
	
	log_msg echo ""
	log_msg echo "Puedes elegir la versión de MySQL que quieres instalar"
	if ask "MySQL 5.x RECOMENDADO. ¿Deseas instalar esta versión? Si eliges 'no', se instalará MySQL 4.x. " "S";then
		mysqlversion=5
		log_msg echo "Se instalará MySQL 5."
	else
		mysqlversion=4
		log_msg echo "Se instalará MySQL 4"
	fi
	
	echo ""
	log_msg echo ""
	if [ silent ]; then
		printf "Usando la contraseña de root de MySQL por defecto..."
	else
		printf "Elige la contraseña del usuario root del MySQL. Intentaremos configurarla por defecto (es posible que quede en blanco): "
		read mysql_pass
		# Deshabilito el intento de configuración de password, tiene más inconvenientes que ventajas.
		# Aún lo pedimos porque así importamos la base de datos de prueba automáticamente usando este password.
		#debconf-set-selections <<< "mysql-server mysql-server/root_password password $mysql_pass"
	fi
	
	echo ""
	if [ silent ]; then
		echo "Todo listo. Iniciando instalación..."
	else
		echo "Todo listo. Pulsa una tecla para iniciar la instalación o CTRL+C para detenerla...."
		read
	fi
}

squeeze()
{
	log_msg echo "Instalación en Debian 6 Squeeze"
	log_msg echo " - Apache 2.2 + PHP 5.3"
	log_msg echo " - MySQL (versión a elegir)"
	log_msg echo " - BackOffice 7.5.35"
}
wheezy()
{
	log_msg echo "Instalación en Debian 7 Wheezy"
	log_msg echo " - Apache 2.2 + PHP 5.4"
	log_msg echo " - MySQL (versión a elegir)"
	log_msg echo " - BackOffice 7.5.35"
}
jessie()
{
	log_msg echo "Instalación en Debian 8 Jessie"
	log_msg echo " - Apache 2.4 + PHP 5.6"
	log_msg echo " - MySQL (versión a elegir)"
	log_msg echo " - BackOffice 7.5.35"
	log_msg echo "Activando repositorios non-free"
	cp ./debian_jessie/non-free.list /etc/apt/sources.list.d/
}

stretch()
{
	log_msg echo "Instalacion en Debian 9 Stretch"
	log_msg echo " - Apache 2.4 + PHP 5.6 o PHP 7"
	log_msg echo " - MySQL (versión a elegir)"
	log_msg echo " - BackOffice 7.5.35"
        # Si los repositorios contrib y non-free no están activados en /etc/apt/sources.list, los activamos
        if grep -q -i 'contrib' /etc/apt/sources.list; then
                log_msg echo "Repositorio contrib ya acivado"
        else
                log_msg echo "Activando repositorio contrib"
                cp ./debian_stretch/contrib.list /etc/apt/sources.list.d/
        fi
        if grep -q -i 'non-free' /etc/apt/sources.list; then
                log_msg echo "Repositorio non-free ya acivado"
        else
                log_msg echo "Activando repositorio non-free"
                cp ./debian_stretch/non-free.list /etc/apt/sources.list.d/
        fi


        log_msg echo ""
        log_msg echo "Puedes elegir la versión de PHP que quieres instalar"
        if ask "Puedes instalar PHP 5.6 o PHP 7 (RECOMENDADO PHP 5.6, que es la que se instala por defecto). ¿Quieres instalar PHP 5.6?" "S"; then
                phpversion=5
                log_msg echo "Se instalará PHP 5.6"
        else
                phpversion=7
                log_msg echo "Se instalará PHP 7.0"
        fi

}

ubuntu_16_4_xenial()
{
	log_msg echo "Instalacion en Ubuntu 16.4 LTS"
	log_msg echo " - Apache 2.4 + PHP 7"
	log_msg echo " - MySQL (versión a elegir)"
	log_msg echo " - BackOffice 7.5.35"
        log_msg echo "Activando repositorio multiverse"
        cp ./ubuntu_16_4/multiverse.list /etc/apt/sources.list.d/
        phpversion=7
}

arquitectura()
{
	# COMPROBAMOS LA ARQUITECTURA DE LA DISTRO
	ARQ=$(uname -m)
	if test "$ARQ" = "x86_64"
	then
		BITS=64
	else
		BITS=32
	fi
	log_msg echo "Arquitectura $BITS"
}

distro()
{
	# COMPROBAMOS LA VERSIÓN DE LA DISTRIBUCIÓN DE DEBIAN
	VERSION=`cat /etc/debian_version`
	if [ "$VERSION" = "stretch/sid" ]; then
		log_msg echo "Ubuntu Xenial 16.4"
		VERSION="xenial"
	else
		VERSION=$(cat /etc/debian_version | awk '{ print(substr($0, 0, 4)) }' | cut -d. -f1)
		log_msg echo "Versión Debian: $VERSION"
	fi
}

paquetes()
{
	# DEBIAN SQUEEZE
	if test "$VERSION" = "6"
	then
		common1
		squeeze
		common2
		# Debian Squeeze, no es necesario hacer nada para tener PHP 5.3
		echo "Instalación en Debian Squeeze"
		echo ""
		log_msg echo "Actualizamos paquetes"
		apt-get update
        if ! exitCode $?; then exit 1; fi
		log_msg echo "Instalación de todos los paquetes necesarios."
		echo ""
		apt-get install -qy curl freetds-dev dpkg-dev openjdk-6-jre rar unrar samba telnetd ssh netcat-openbsd libapache2-mod-php5 php5 php5-common php5-imap php5-curl php5-gd php5-odbc php5-mysql php5-xsl php5-sybase php-soap php-pear sudo
		if ! exitCode $?; then exit 1; fi
	fi


	# DEBIAN WHEEZY
	if test "$VERSION" = "7"
		then
		common1
		wheezy
		common2
		# Debian Wheezy, tenemos que utilizar los paquetes de Squeeze
		log_msg echo "Instalación en Debian Wheezy o superior. Utilizaremos los paquetes de Debian Squeeze para instalar PHP 5.3"
		echo ""
		log_msg echo "Actualizamos paquetes"
		apt-get update
		if ! exitCode $?; then exit 1; fi
		echo ""
		echo "Instalación de todos los paquetes necesarios."
		apt-get install -qy curl freetds-dev dpkg-dev openjdk-6-jre rar unrar samba telnetd ssh netcat-openbsd libapache2-mod-php5 php5 php5-common php5-imap php5-curl php5-gd php5-odbc php5-mysql php5-xsl php5-sybase php-soap php-pear dos2unix sudo
		if ! exitCode $?; then exit 1; fi
	fi


	# DEBIAN JESSIE
	if test "$VERSION" = "8"
	then
		common1
		jessie
		common2
		# Debian Jessie, actualizamos paquetes
		echo "Instalación en Debian Jessie 8"
		echo ""
		log_msg echo "Actualizamos paquetes"
		apt-get update
		if ! exitCode $?; then exit 1; fi
		echo ""
		log_msg echo "Instalación de todos los paquetes necesarios."
		apt-get install -qy curl freetds-dev dpkg-dev openjdk-7-jre openjdk-7-jdk \
								 rar unrar samba telnetd telnet ssh netcat-openbsd \
								 libapache2-mod-php5 php5 php5-common php5-imap php5-curl php5-gd php5-odbc php5-mysql php5-xsl \
								 php5-sybase php-soap php-pear php5-mcrypt \
								 dos2unix sudo
		if ! exitCode $?; then exit 1; fi
	fi

	# DEBIAN STRETCH o UBUNTU 16.4 LTS (stretch/sid)
	if [ "$VERSION" = "9" -o "$VERSION" = "xenial" ]; 
	then
		common1
		if [ "$VERSION" = "9" ]; then
			stretch
		else
			ubuntu_16_4_xenial
			phpversion=7
		fi
		common2
		# Debian Stretch, actualizamos paquetes
		if [ "$VERSION" = "9" ]; then
			echo "Instalación en Debian Stretch 9"
		else
			echo "Instalación en Ubuntu 16.4 LTS"
		fi
		echo ""
	        if [ "$phpversion" = "5" ];then
			echo "Instalando repositorios de PHP 5"
			cp ./debian_stretch/php5.list /etc/apt/sources.list.d
			cp ./debian_stretch/preferences.d.jessie /etc/apt/preferences.d/jessie
		fi

		log_msg echo "Actualizamos paquetes"
		apt-get update
		if ! exitCode $?; then exit 1; fi
		echo ""

		# Instalamos todos los paquetes comunes a PHP 7 y PHP 5
		log_msg echo "Instalación de todos los paquetes necesarios para PHP 7.0."
		apt-get install -qy curl freetds-dev dpkg-dev openjdk-8-jre openjdk-8-jdk \
					    rar unrar samba sysv-rc-conf telnetd telnet ssh netcat-openbsd nano \
					    libapache2-mod-php php php-common php-imap php-curl php-gd php-odbc php-mysql php-xsl php-sybase php-mcrypt php7.0-mbstring php-zip \
					    php-soap php-pear dos2unix \
					    php-dev unixodbc unixodbc-dev \
					    sudo curl apt-transport-https
		if ! exitCode $?; then exit 1; fi

		if [ "$phpversion" = "5" ];then
			# Instalamos también PHP 5 (que es el que activaremos)
			log_msg echo "Instalación de todos los paquetes necesarios para PHP 5.6."
			
			# En primer lugar, bajamos un paquete de Wheezy que necesitamos porque si no lo hacemos nos dará un error al instalar php5-gd
			apt-get install -qy wget
			wget http://ftp.es.debian.org/debian/pool/main/libp/libpng/libpng12-0_1.2.49-1+deb7u2_amd64.deb
			dpkg -i libpng12-0_1.2.49-1+deb7u2_amd64.deb
			
			# Ahora lanzamos la instalación normal
			apt-get install -qy \
						libapache2-mod-php5 php5 php5-common php5-imap php5-curl php5-gd php5-odbc php5-mysql php5-xsl php5-sybase php5-mcrypt php-mbstring
			if ! exitCode $?; then exit 1; fi
		fi

		# Instalamos el driver sqlsrv, que sólo es compatible con PHP 7
		log_msg echo "Instalación del driver de acceso a SQL Server (sqlsrv). IMPORTANTE: Sólo es compatible con PHP 7"
		pecl install sqlsrv
		# Para evitar problemas de acceso a SQL Server, añadimos el locale en_US.UTF-8
		apt-get install -y locales && echo "en_US.UTF-8 UTF-8" > /etc/locale.gen && locale-gen

		# Instalamos también las herramientas de acceso a SQL Server de Microsoft
		log_msg echo "Instalación de las herramientas de acceso a SQL Server (sqlcmd)"
		curl https://packages.microsoft.com/keys/microsoft.asc | sudo apt-key add 
		curl https://packages.microsoft.com/config/ubuntu/16.04/prod.list | sudo tee /etc/apt/sources.list.d/msprod.list
		apt-get update
		ACCEPT_EULA=Y apt-get install -y mssql-tools unixodbc-dev
		echo 'export PATH="$PATH:/opt/mssql-tools/bin"' >> ~/.bashrc
		source ~/.bashrc

		# Instalar driver de ODBC (https://docs.microsoft.com/es-es/sql/connect/odbc/linux-mac/installing-the-microsoft-odbc-driver-for-sql-server)
		curl -s https://packages.microsoft.com/keys/microsoft.asc | apt-key add -
		curl -s https://packages.microsoft.com/config/debian/8/prod.list > /etc/apt/sources.list.d/mssql-release.list
		sudo apt-get update
		sudo ACCEPT_EULA=Y apt-get install msodbcsql
		#if ! exitCode $?; then exit 1; fi

		# En Debian Stretch, no tendremos la librería libssl.so.1.0.0
		# La instalamos manualmente
		if [ "$VERSION" = "9" ]; 
		then
			wget http://ftp.us.debian.org/debian/pool/main/o/openssl/libssl1.0.0_1.0.2l-1~bpo8+1_amd64.deb
			dpkg -i libssl1.0.0_1.0.2l-1~bpo8+1_amd64.deb
		fi
		
		# Instalar nodejs
		wget -qO- https://deb.nodesource.com/setup_8.x | sudo -E bash -
        sudo apt-get install -y nodejs build-essential
		npm install -g forever
	fi

	# Activamos el parámetro UseDNS no para que el login por ssh sea inmediato
	SSH=$(cat /etc/ssh/sshd_config | grep UseDNS | cut -d" " -f1)

	if test "$SSH" != "UseDNS"
	then
		echo "UseDNS no" >> /etc/ssh/sshd_config 2> /dev/null
	fi
}

pearinstall()
{
	echo ""
	log_msg echo ""
	log_msg echo "Instalación del driver MDB2 de mssql"
	pear install --nodeps MDB2_Driver_mssql
#        if ! exitCode $?; then exit 1; fi
	log_msg echo "Instalación de Net_Ping"
	pear install Net_Ping
#        if ! exitCode $?; then exit 1; fi

	echo "Paquetes instalados."
	echo ""
}

configuracion()
{
	if [ "$conffiles" = "s" ];then
		mkdir $ruta_backup/$fecha
		
		log_msg echo "Realizamos un backup de los ficheros de configuración en la ruta $ruta_backup/$fecha"
		log_msg echo ""
		
		# Creamos una copia de los ficheros de configuración originales: 
		mkdir -p $ruta_backup/$fecha/etc/mysql/
		mkdir -p $ruta_backup/$fecha/etc/php5/apache2/
		mkdir -p $ruta_backup/$fecha/etc/apache2/sites-enabled/
		mkdir -p $ruta_backup/$fecha/etc/apache2/sites-available/
		mkdir -p $ruta_backup/$fecha/etc/apache2/conf.d/
		mkdir -p $ruta_backup/$fecha/etc/apache2/mods-enabled/
		mkdir -p $ruta_backup/$fecha/etc/apache2/mods-available/
		
		cp /etc/mysql/my.cnf $ruta_backup/$fecha/etc/mysql/my.cnf 2> /dev/null
		cp /etc/mysql.conf $ruta_backup/$fecha/etc/mysql.conf 2> /dev/null
		cp /etc/php5/apache2/php.ini $ruta_backup/$fecha/etc/php5/apache2/php.ini 2> /dev/null
		cp /etc/php.ini $ruta_backup/$fecha/etc/php.ini 2> /dev/null
		cp /etc/apache2/apache2.conf $ruta_backup/$fecha/etc/apache2/apache2.conf 2> /dev/null
		cp /etc/apache2/sites-enabled/000-default $ruta_backup/$fecha/etc/apache2/sites-enabled/000-default 2> /dev/null
		cp /etc/apache2/sites-enabled/000-default.conf $ruta_backup/$fecha/etc/apache2/sites-enabled/000-default.conf 2> /dev/null
		cp /etc/apache2/sites-available/000-default.conf $ruta_backup/$fecha/etc/apache2/sites-available/000-default.conf 2> /dev/null
		cp /etc/apache2/mods-enabled/mime.conf $ruta_backup/$fecha/etc/apache2/mods-enabled/mime.conf 2> /dev/null
		cp /etc/apache2/envvars/ $ruta_backup/$fecha/etc/apache2/envvars/ 2> /dev/null
		cp /etc/apache2/conf.d/charset $ruta_backup/$fecha/etc/apache2/conf.d/charset 2> /dev/null
		cp /etc/apache2/mods-enabled/* $ruta_backup/$fecha/etc/apache2/mods-enabled/ 2> /dev/null
		cp /etc/samba/smb.conf $ruta_backup/$fecha/etc/samba/smb.conf 2> /dev/null
		
		log_msg echo "Copia de los archivos de configuración personalizados de Apache y MySQL"
		cp ./my.cnf /etc/mysql 2> /dev/null
		cp ./mysql.conf /etc 2> /dev/null
		chown www-data:www-data /etc/mysql.conf 2> /dev/null
		cp ./php.ini /etc/php5/apache2 2> /dev/null
		cp ./php_ini.dummie /etc/php.ini 2> /dev/null
		cp ./apache2.conf /etc/apache2 2> /dev/null
		cp ./000-default /etc/apache2/sites-enabled 2> /dev/null
		cp ./mime.conf /etc/apache2/mods-enabled 2> /dev/null
		cp ./envvars /etc/apache2 2> /dev/null
		cp -f ./smb.conf /etc/samba/smb.conf 2> /dev/null
		rm /etc/apache2/mods-enabled/reqtimeout.* 2> /dev/null
		
		if [ "$VERSION" = "8" ]
		then
			log_msg echo "Copiamos ficheros de configuración de Apache 2.4 y PHP 5.6"
			cp -rf ./debian_jessie/apache2.conf /etc/apache2/apache2.conf
			cp -rf ./debian_jessie/000-default /etc/apache2/sites-enabled/
			cp -rf ./debian_jessie/000-default.conf /etc/apache2/sites-enabled/
			cp -rf ./debian_jessie/sites-available_000-default.conf /etc/apache2/sites-available/000-default.conf
			cp -rf ./debian_jessie/php.ini /etc/php5/apache2/php.ini
		fi

		if [ "$VERSION" = "9" -o "$VERSION" = "xenial" ]
		then
			log_msg echo "Copiamos ficheros de configuración de Apache 2.4 y PHP"
			cp -rf ./debian_stretch/apache2.conf /etc/apache2/apache2.conf
			cp -rf ./debian_stretch/000-default /etc/apache2/sites-enabled/
			cp -rf ./debian_stretch/000-default.conf /etc/apache2/sites-enabled/
			cp -rf ./debian_stretch/sites-available_000-default.conf /etc/apache2/sites-available/000-default.conf
			# Copiamos el archivo php.ini tanto para PHP 5 como para PHP 7
			if [ -e /etc/php5/apache2 ]; then
				cp ./debian_stretch/php.ini /etc/php5/apache2/php.ini
			fi
			if [ -e /etc/php/7.0/apache2 ]; then
				cp ./debian_stretch/php.ini /etc/php/7.0/apache2/php.ini
			fi
			if [ "$phpversion" = "5" ];then
				log_msg echo "Activando módulo PHP 5"
				a2enmod php5
				a2dismod php7.0
			else
				log_msg echo "Activando módulo PHP 7"
				a2enmod php7.0
				a2dismod php5
			fi
			# Activamos la extensión sqlsrv (para PHP 7.0)
			echo 'extension=sqlsrv.so' >> /etc/php/7.0/apache2/php.ini
			
			if [ ! -e /var/lib/php5 ]; then
				mkdir /var/lib/php5
				chown www-data. /var/lib/php5
			fi
			if [ ! -e /var/lib/php5/sessions ]; then
				mkdir /var/lib/php5/sessions
				chown www-data. /var/lib/php5/sessions
			fi

			service apache2 restart
		fi
	fi
	
        if [ $docker -eq 1 ]; then
                echo "Instalando en Docker. No se arrancan los servicios"
        else
                # Tareas que no hay que realizar en docker pero sí en instalación a pelo
		log_msg echo ""
		log_msg echo "Reinicio samba (smbd)"
		/etc/init.d/smbd restart
		if ! exitCode $?; then exit 1; fi
		log_msg echo ""
		log_msg echo "Habilitando módulos de Apache"
		log_msg echo "a2enmod expires"
		a2enmod expires
	    if ! exitCode $?; then exit 1; fi
		log_msg echo "a2enmod rewrite"
		a2enmod rewrite
	    if ! exitCode $?; then exit 1; fi
		log_msg echo "a2enmod headers"
		a2enmod rewrite
	    if ! exitCode $?; then exit 1; fi
		log_msg echo ""
		echo ""
        fi
}

ioncube()
{
	log_msg echo "Instalamos Ioncube"
	mkdir /var/www/ViewOffice
	cp -R ./www/ioncube/ /var/www/ViewOffice

	if test "$VERSION" = "6"
	then
		log_msg echo "En squeeze forzamos el uso de ioncube 5.3 con el fichero /etc/php5/apache2/conf.d/20ioncube.ini"
		cp ./20ioncube.ini /etc/php5/apache2/conf.d/20ioncube.ini 2> /dev/null
	fi

	if test "$VERSION" = "7"
	then
		mkdir /usr/lib/php5/ioncube_loader/
		log_msg echo "Copiamos el php.ini para Wheezy (php 5.4)"
		cp ./php.ini.WHEEZY /etc/php5/apache2/php.ini
	        if ! exitCode $?; then exit 1; fi
		log_msg echo "Copiamos los ficheros de ioncube"
		cp ./www/ioncube/ioncube_loaders_lin_x86/* /usr/lib/php5/20100525+lfs/
	        if ! exitCode $?; then exit 1; fi
	fi

	if test "$VERSION" = "8"
	then
		mkdir /usr/lib/php5/ioncube_loader/
		log_msg echo "Copiamos los ficheros de ioncube"
		cp -r ./www/ioncube/* /usr/lib/php5/ioncube_loader/
		if ! exitCode $?; then exit 1; fi
		log_msg echo "Copiamos el php.ini adecuado en función de la arquitectura"
		if [ $BITS = 64 ];
		then
			log_msg echo "Debian Jessie 64 bits - Activamos ioncube de 64 bits"
			cp -rf ./debian_jessie/php64.ini /etc/php5/apache2/php.ini
			if ! exitCode $?; then exit 1; fi
		else
			log_msg echo "Debian Jessie 32 bits - Activamos ioncube de 32 bits"
			cp -rf ./debian_jessie/php.ini /etc/php5/apache2/php.ini
			if ! exitCode $?; then exit 1; fi
		fi
	fi

	if [ "$VERSION" = "9" -o "$VERSION" = "xenial" ]
	then
		mkdir /usr/lib/php/ioncube_loader/
		log_msg echo "Copiamos los ficheros de ioncube"
		cp -r ./www/ioncube/* /usr/lib/php/ioncube_loader/
		if ! exitCode $?; then exit 1; fi
		log_msg echo "Copiamos el php.ini adecuado en función de la arquitectura"
		if [ $BITS = 64 ];
		then
			log_msg echo "Debian Stretch 64 bits - Activamos ioncube de 64 bits"
			if [ -e /etc/php/7.0/apache2/php.ini ]; then
				`sed -i '1s/^/zend_extension = \/usr\/lib\/php\/ioncube_loader\/ioncube_loaders_lin_x86-64\/ioncube_loader_lin_7.0.so \n\n/' /etc/php/7.0/apache2/php.ini`
				if ! exitCode $?; then exit 1; fi
			fi
			if [ -e /etc/php5/apache2/php.ini ]; then
				`sed -i '1s/^/zend_extension = \/usr\/lib\/php\/ioncube_loader\/ioncube_loaders_lin_x86-64\/ioncube_loader_lin_5.6.so \n\n/' /etc/php5/apache2/php.ini`
				if ! exitCode $?; then exit 1; fi
			fi
		else
			log_msg echo "Debian Stretch 32 bits - Activamos ioncube de 32 bits"
			if [ -e /etc/php/7.0/apache2/php.ini ]; then
				sed -i '1s/^/zend_extension = \/usr\/lib\/php\/ioncube_loader\/ioncube_loaders_lin_x86\/ioncube_loader_lin_7.0.so \n\n/' /etc/php/7.0/apache2/php.ini
				if ! exitCode $?; then exit 1; fi
			fi
			if [ -e /etc/php5/apache2/php.ini ]; then
				sed -i '1s/^/zend_extension = \/usr\/lib\/php\/ioncube_loader\/ioncube_loaders_lin_x86\/ioncube_loader_lin_5.6.so \n\n/' /etc/php5/apache2/php.ini
				if ! exitCode $?; then exit 1; fi
			fi
		fi
	fi

	if [ $BITS = 64 ];
	then
		log_msg echo "Ejecutamos script de ioncube en distro de 64 bits"
		chmod +x /var/www/ViewOffice/ioncube/ioncube_loaders_lin_x86-64/install.php
		dos2unix /var/www/ViewOffice/ioncube/ioncube_loaders_lin_x86-64/install.php
		/var/www/ViewOffice/ioncube/ioncube_loaders_lin_x86-64/install.php >> /dev/null
		if ! exitCode $?; then exit 1; fi
	else
		log_msg echo "Ejecutamos script de ioncube en distro de 32 bits"
		chmod +x /var/www/ViewOffice/ioncube/ioncube_loaders_lin_x86/install.php
		dos2unix /var/www/ViewOffice/ioncube/ioncube_loaders_lin_x86/install.php
		/var/www/ViewOffice/ioncube/ioncube_loaders_lin_x86/install.php >> /dev/null
		if ! exitCode $?; then exit 1; fi
	fi
	

        if [ $docker -eq 1 ]; then
                echo "Instalando en Docker. No se arrancan los servicios"
        else
		log_msg echo ""
		log_msg echo "Reiniciamos apache2"
		# Intentamos apagar correctamente el servicio. Si por algún motivo no se apaga, lo mataremos
		# y lo arrancamos de nuevo
		/etc/init.d/apache2 stop
		killall -9 -v apache2
		/etc/init.d/apache2 start
		if ! exitCode $?; then exit 1; fi
        fi
}


netoffice()
{
	log_msg echo ""
	log_msg echo "Instalación del NetOffice"
	mkdir /usr/local/NetOffice
	cp ./NetOffice /usr/local -R
	# En Debian Jessie el script de NetOffice será ligeramente distinto
	if [ "$VERSION" = "xenial" ]; then
		cp ./debian_jessie/netoffice /usr/local/NetOffice/netoffice
	else
		if [ "$VERSION" -gt "7" ]; then
			cp ./debian_jessie/netoffice /usr/local/NetOffice/netoffice
		fi
	fi
	chown -R www-data. /usr/local/NetOffice
	chmod a+rw /usr/local/NetOffice -R
	cp /usr/local/NetOffice/netoffice /etc/init.d
	chmod a+x /etc/init.d/netoffice
	update-rc.d netoffice defaults
}


backoffice()
{
	echo ""
	log_msg echo "Instalación del BackOffice"
	mkdir -p /var/www/ 2> /dev/null
	cp ./www/index.html /var/www
	#cp ./www/phpinfo.php /var/www

        if [ $docker -eq 1 ]; then
                echo "Instalador de Docker. No se instala la última nightly"
                cp -r ./www/ViewOffice/* /var/www/ViewOffice
                chmod +x /var/www/ViewOffice/bin/unrar
                chmod +x /var/www/ViewOffice/bin/unrar64
        else
		# Eliminamos y creamos de nuevo la carpeta last_version_binary por si hemos lanzado dos veces el instalador (tener siempre
		# la última versión "limpia")
		rm -rf last_version_binary
		mkdir last_version_binary
		cd last_version_binary
	        if [ "$phpversion" = "5" ];then
			# Descargamos la última LTS
			log_msg echo "Buscando la última versión LTS disponible"
			url=$(curl -s "http://downloads.icssolution.com/api/LTS/RELEASES?format=plain" | head -n1 | awk '{print $1;}')
	        else
			# Descargamos la última nightly Cutting Edge
			log_msg echo "Buscando la última versión Cutting Edge disponible para PHP 7"
			url=$(curl -s "http://downloads.icssolution.com/api/CuttingEdge/RELEASES?nightly=true&format=plain&php7=true" | head -n1 | awk '{print $1;}')
	        fi
	        if ! exitCode $?; then exit 1; fi

		log_msg echo "Descargando la última versión desde $url"
		apt-get install -qy wget	
		wget $url

		unrar x -o+ *.rar /var/www 2> /dev/null
		#cp ./www /var -R
	        if ! exitCode $?; then exit 1; fi
	        cd ..
	fi
	# Copiamos el archivo de configuración
	mkdir /var/www/ViewOffice/etc/
	cp ./www/config.xml /var/www/ViewOffice/etc/config.xml
    if [ "$phpversion" = "5" ];then
                # Con PHP 5, usamos la extensión mysql
		sed -i -- 's/<motor_base_datos>mysqli</<motor_base_datos>mysql</g' /var/www/ViewOffice/etc/config.xml
    else
                # Con PHP 7, usamos mysqli
		sed -i -- 's/<motor_base_datos>mysql</<motor_base_datos>mysqli</g' /var/www/ViewOffice/etc/config.xml
    fi

	# Creamos algunos archivos y ajustamos permisos
	touch /var/www/status.txt
	touch /var/www/ViewOffice/status.txt
	mkdir /var/www/ViewOffice/patches
        mkdir /var/www/ViewOffice/imgs
	chown -R www-data. /var/www
	chmod -R 777 /var/www/ViewOffice/imgs
	chmod -R 700 /var/www/ViewOffice/patches
}

backup()
{
	echo ""
	log_msg echo "Creación de la carpeta /home/backup"
	mkdir /home/backup 2> /dev/null
	mkdir /home/backup/lunes 2> /dev/null
	mkdir /home/backup/martes 2> /dev/null
	mkdir /home/backup/miercoles 2> /dev/null
	mkdir /home/backup/jueves 2> /dev/null
	mkdir /home/backup/viernes 2> /dev/null
	mkdir /home/backup/sabado 2> /dev/null
	mkdir /home/backup/domingo 2> /dev/null
	chown www-data:www-data /home/backup -R
	chmod a+r /home/backup
}

mysql4_64()
{
	if [ "$BITS" = "64" ];then
		./install_mysql4_64.sh
	else
		./install_mysql4.sh
	fi
}

mysql()
{
	if [ "$mysqlversion" = "4" ];then
		log_msg echo "Instalación de MySQL 4.1.22"
		mysql4_64
	elif [ "$mysqlversion" = "5" ]; then
		log_msg echo "Instalación de MySQL 5.5"
		log_msg echo "Recuerda: Para que el FrontOffice funcione correctamente deberás instalar la versión 5.1 de ODBC en los clientes"
		echo ""
		echo "Instalando MySQL5"
		./install_mysql5.sh $mysql_pass
	fi
}

#
# FIN DE DEFINICIÓN DE FUNCIONES
#




#
# SCRIPT DE INSTALACIÓN DEL BACKOFFICE
#

# Comprobamos la versión de la distro
distro
# Comprobamos la arquitectura de la distro
arquitectura
# Instalación de paquetes
paquetes
pearinstall
# Copiamos archivos de configuración
configuracion
if [ $silent -eq 1 ]; then
     log_msg echo "Instalador silent. No se instala Ioncube ni NetOffice"
else
    # Instalación de ioncube
    ioncube
    # Instalación del NetOffice
    netoffice
fi
# Instalación del BackOffice
backoffice
# Creación de la carpeta backup
backup
# Instalación de mysql
mysql

log_msg echo ""
log_msg echo "Ha finalizado la instalación del BackOffice"
