#!/bin/bash

echo "INSTALACIÓN DE BACKOFFICE"
echo ""
echo "RECUERDA QUE TIENES QUE EJECUTAR ESTE SCRIPT COMO 'root'."
echo " su root"
echo " ./install_backoffice_suse.sh"
echo ""
echo "ESTE SCRIPT DE INSTALACIÓN INSTALARÁ:"
echo " - Apache2 + PHP"
echo " - MySQL 5"
echo " - BackOffice 7.1.45"
echo " - Una base de datos de ejemplo"
echo ""
echo "EJECUTA TAMBIÉN "
echo " sudo ./activar_vnc_suse.sh"
echo "PARA ACTIVAR EL ACCESO POR VNC AL SERVIDOR"
echo ""
echo ""
echo "Pulsa una tecla para iniciar la instalación o CTRL+C para detenerla...."

read

ARQ=$(uname -m)
if test "$ARQ" = "x86_64"
then
  BITS=64
else
  BITS=32
fi

echo "Instalación de todos los paquetes 
necesarios."
echo ""
# Falta:
# freetds-dev dpkg-dev msttcorefonts x-ttcidfont-conf php5-net-ping samba
zypper install apache2-prefork apache2-mod_php5 freetds-dev php5-devel php5-ftp rar nano php5 php5-curl php5-gd php5-imap php5-mysql php5-odbc php5-pear php5-soap php5-xsl yast2-sshd mysql-administrator java-1_6_0-sun netcat-openbsd
 
# Instalacion de mysql 5
#apt-get install mysql-server mysql-client

echo "Paquetes instalados."
echo ""
echo "Instalando extensiones de PHP..."
if [ $BITS = 64 ];
then
	cp ./php_extensions/* /usr/lib64/php5/extensions
else
        cp ./php_extensions/* /usr/lib/php5/extensions
fi

echo "Creación del usuario www-data"
groupadd www-data
useradd www-data -G www-data --system -d /var/lib/wwwrun
chown -R www-data:www-data /var/lib/wwwrun
chown -R www-data:www-data /var/lib/php5

echo ""
echo "Copia de los archivos de configuración personalizados de Apache y MySQL"
insserv -d /etc/init.d/apache2
cp ./my.cnf /etc/mysql
cp ./mysql.conf /etc
chown www-data:www-data /etc/mysql.conf
cp ./php.ini /etc/php5/apache2
cp ./php_ini.dummie /etc/php.ini
cp ./suse/uid.conf /etc/apache2
cp ./suse/httpd.conf.local /etc/apache2
cp ./suse/default-server.conf /etc/apache2
cp ./suse/apache2 /etc/sysconfig
cp ./000-default /etc/apache2/sites-enabled
cp ./mime.conf /etc/apache2/mods-enabled
cp ./envvars /etc/apache2
cp ./charset /etc/apache2/conf.d

echo "Instalando NET::Ping"
pear install net_ping
cat php_ping_suse >> /etc/php5/apache2/php.ini

#echo ""
#echo "Permitir acceso remoto a MySQL"
#mysql --user=root mysql < ./usuarios_mysql5.sql

#echo ""
#echo "Reiniciar MySQL"
#/etc/init.d/mysql restart

#echo ""
#echo "Instalación de la base de datos de ejemplo"
#mysql --user=root < ./crear_bd.sql
#mysql --user=root ViewOffice < ./nueva.sql

#echo ""
#echo "Instalación de Zend Optimizer"
#mkdir /usr/local/Zend
#cp ./Zend /usr/local -R
#chmod a+rw /usr/local/Zend -R

echo ""
echo "Instalación del NetOffice"
mkdir /usr/local/NetOffice
cp ./NetOffice /usr/local -R
chmod a+rw /usr/local/NetOffice -R
cp /usr/local/NetOffice/netoffice_suse /etc/init.d/netoffice
chmod a+x /etc/init.d/netoffice
insserv -d /etc/init.d/netoffice

echo ""
echo "Instalación del BackOffice"
unrar x -o+ ./www/ViewOffice.rar /var/www
#cp ./www /var -R
chown www-data:www-data /var/www -R
chmod a+rw /var/www -R

#echo ""
#echo "Instalación de las fuentes TTF"
#cp ./fonts/* /usr/share/fonts/truetype/msttcorefonts
#fc-cache -f -v

chmod a+rw /usr/local/NetOffice -R

echo ""
echo "Creación de la carpeta /home/backup"
mkdir /home/backup
mkdir /home/backup/lunes
mkdir /home/backup/martes
mkdir /home/backup/miercoles
mkdir /home/backup/jueves
mkdir /home/backup/viernes
mkdir /home/backup/sabado
mkdir /home/backup/domingo
chown www-data:www-data /home/backup -R
chmod a+r /home/backup

