#!/bin/sh

echo "Aadiendo usuario y grupo para MySQL..."
groupadd mysql
useradd -g mysql mysql

echo "Copiando archivos de instalacin...."
cp mysql-standard-4.1.22-pc-linux-gnu-i686-glibc23.tar.gz /usr/local

echo "Copiando archivos de configuracin..."
case "${1:-''}" in
  'lowmem')
	echo "Opcin ''lowmem'' activada (para mquinas con poca RAM)"
	cp my.cnf_lowmem /usr/local/my.cnf
      ;;
  *)    echo "Configuracin para mquinas con > 512MB de RAM"
	cp my.cnf /usr/local/my.cnf
      ;;
esac

echo "Descomprimiendo archivos...."
mkdir /usr/local/mysql_ext
cp ./mysql_ext/* /usr/local/mysql_ext -R
cp usuarios_mysql.sql /usr/local
cd /usr/local
gunzip < mysql-standard-4.1.22-pc-linux-gnu-i686-glibc23.tar.gz | tar xvf -
ln -s mysql-standard-4.1.22-pc-linux-gnu-i686-glibc23 mysql
cd mysql

echo "Ejecutando script de instalacin..."
scripts/mysql_install_db --user=mysql
chown -R root  .
chown -R mysql data
chgrp -R mysql .
mkdir /var/lib/mysql
cp ./data/* /var/lib/mysql -R
chown -R mysql:mysql /var/lib/mysql
cd /usr/local

echo "Copiando archivos de configuracin ...."
mkdir /etc/mysql
mkdir /etc/mysql/conf.d
cp my.cnf /etc/mysql/my.cnf
cp ./mysql_ext/config/* /etc/mysql -R
chmod a-w /etc/mysql -R
chmod a+r /etc/mysql -R
chmod a+x /etc/mysql/debian-start
chown mysql:mysql /etc/mysql -R
ln -s /etc/mysql/my.cnf /etc/my.cnf
mkdir /usr/share/mysql
cp ./mysql_ext/mysql/* /usr/share/mysql -R
chmod a+rw /usr/share/mysql/* -R
cp ./mysql_ext/init.d/mysql /etc/init.d
chmod a+x /etc/init.d/mysql
mkdir /var/run/mysqld
chown mysql:mysql /var/run/mysqld
chmod a+rwx /var/run/mysqld
update-rc.d mysql defaults

echo "Aadiendo al PATH..."
cat ./mysql_ext/bash.bashrc >> /etc/bash.bashrc

echo "Borrando archivos de instalacin...."
rm mysql-standard-4.1.22-pc-linux-gnu-i686-glibc23.tar.gz
rm -r /usr/local/mysql_ext

echo "Iniciando MySQL...."
/etc/init.d/mysql start

echo "Creando usuarios...."
/usr/local/mysql/bin/mysql --user=root mysql < /usr/local/usuarios_mysql.sql
rm /usr/local/usuarios_mysql.sql

echo "Importando base de datos de ejemplo..."
mysqladmin create ViewOffice
mysql ViewOffice < ./nueva.sql

echo "Instalacin finalizada."
echo ""
echo "Si la base de datos no inicia, es posible que la mquina no disponga de suficiente memoria RAM. Prueba la instalacin con la opcin lowmem:"
echo ""
echo "./install_mysql4.sh lowmem"
