#!/bin/sh

echo "Añadiendo grupo y usuario mysql"
groupadd mysql
useradd mysql -G mysql --system -d /var/lib/mysql
echo "Copiando 
archivos"
cp mysql-standard-4.1.22-unknown-linux-gnu-x86_64-glibc23.tar.gz /usr/local
cp my.cnf /usr/local
mkdir /usr/local/mysql_ext
cp ./mysql_ext/* /usr/local/mysql_ext -R
cp usuarios_mysql.sql /usr/local
cd /usr/local
echo "Descomprimiendo archivo"
gunzip < mysql-standard-4.1.22-unknown-linux-gnu-x86_64-glibc23.tar.gz | tar xvf -
rm /usr/local/mysql
ln -s mysql-standard-4.1.22-unknown-linux-gnu-x86_64-glibc23 mysql
cd mysql
echo "Ejecuntando script de instalación"
cd /usr/local/mysql
scripts/mysql_install_db --user=mysql --basedir=/usr/local/mysql
echo "Cambiando propietario de los archivos"
chown -R root  .
chown -R mysql data
chgrp -R mysql .
echo "Creando carpeta de datos"
mkdir /var/lib/mysql
echo "Copiando archivos de datos"
cp ./data/* /var/lib/mysql -R
chown -R mysql:mysql /var/lib/mysql
cd /usr/local
echo "Copiando los nuevos archivos de configuración"
rm -r /etc/mysql
mkdir /etc/mysql
mkdir /etc/mysql/conf.d
cp my.cnf /etc/mysql/my.cnf
cp ./mysql_ext/config/* /etc/mysql -R
chmod a-w /etc/mysql -R
chmod a+r /etc/mysql -R
chmod a+x /etc/mysql/debian-start
chown mysql:mysql /etc/mysql -R
ln -s /etc/mysql/my.cnf /etc/my.cnf
echo "Creando directorio /usr/share/mysql"
mkdir /usr/share/mysql
cp ./mysql_ext/mysql/* /usr/share/mysql -R
chmod a+rw /usr/share/mysql/* -R
echo "Copiando script de inicio de la base de datos"
cp ./mysql_ext/init.d/mysql_suse /etc/init.d/mysql
chmod a+x /etc/init.d/mysql
mkdir /var/run/mysqld
chown mysql:mysql /var/run/mysqld
chmod a+rwx /var/run/mysqld
rm -r /usr/local/mysql_ext
echo "Instalando servicio"
insserv -d /etc/init.d/mysql
echo "Borrando archivos de instalación"
rm mysql-standard-4.1.22-unknown-linux-gnu-x86_64-glibc23.tar.gz
echo "Iniciando servicio"
/etc/init.d/mysql start
echo "Conectando con la base de datos y creando usuarios"
/usr/local/mysql/bin/mysql --user=root mysql < /usr/local/usuarios_mysql.sql
rm /usr/local/usuarios_mysql.sql

