#!/bin/bash
LOG=./log
PASS=$1
log_msg()
(
	echo $($1) $2
	echo $($1) $2 >> $LOG
)

# Instalamos sudo si no lo está ya
apt-get install sudo -y



log_msg echo "Instalando paquetes MySQL"
if [[ ! -z $PASS ]]; then
	# Asignamos la contrasñea al servidor MySQL
	echo "Contraseña de root para MySQL: $PASS"
	sudo debconf-set-selections <<< "mysql-server mysql-server/root_password password $PASS"
	sudo debconf-set-selections <<< "mysql-server mysql-server/root_password_again password $PASS"

	apt-get install -qy mysql-server mysql-client
else
	# Password en blanco
	echo "Contraseña de root para MySQL EN BLANCO"
	export DEBIAN_FRONTEND=noninteractive
	sudo -E apt-get -q -y install mysql-server mysql-client
	# Para MySQL 5.7, tenemos que especificar el plugin que guarda el password
	echo "ALTER USER 'root'@'localhost' IDENTIFIED WITH mysql_native_password BY '';flush privileges;" | mysql -u root
fi


log_msg echo "Copiando archivos de configuración..."
cp ./debian_jessie/my.cnf /etc/mysql/my.cnf

log_msg echo "Modificando permisos"
chown -R mysql:mysql /var/lib/mysql
log_msg echo "Iniciando MySQL...."
/etc/init.d/mysql start

log_msg echo "Modificando usuario root para dar acceso desde cualquier host"
mysql -u root mysql < usuarios_mysql.sql


echo ""
log_msg echo ""
log_msg echo ""
log_msg echo "Creando base de datos ViewOffice..."
if [[ ! -z $PASS ]]; then
   log_msg echo "Intentando conexión con password"
   mysqladmin -uroot -p"$PASS" create ViewOffice 2> /dev/null
   if test $? -eq 1;
   then
	log_msg echo "Ha fallado la conexión con password. Intentando conexión sin password."
	mysqladmin create ViewOffice 2> /dev/null
	if test $? -eq 1;
	then
		log_msg echo "Contraseña de root desconocida o base de datos ya existente."
	else
		log_msg echo "Base de datos ViewOffice creada correctamente."
	fi
   fi
else
   log_msg echo "Intentando conexión SIN password"
   mysqladmin -uroot create ViewOffice 2> /dev/null
fi
log_msg echo ""

log_msg echo "Importando base de datos de ejemplo..."
if [[ ! -z $PASS ]]; then
   log_msg echo "Intentando conexión con password"
   mysql -uroot -p"$PASS" ViewOffice < ./nueva.sql 2> /dev/null
   if test $? -eq 1;
   then
	log_msg echo "Ha fallado la conexión con password. Intentando conexión sin password."
	mysql ViewOffice < ./nueva.sql 2> /dev/null
	if test $? -eq 1;
	then
		log_msg echo "Contraseña de root desconocida."
		ERROR_MYSQL=1
	else
		log_msg echo "Datos importados correctamente."
	fi
   fi
else
   log_msg echo "Intentando conexión SIN password"
   mysql -uroot ViewOffice < ./nueva.sql 2> /dev/null
fi

log_msg echo ""
log_msg echo "Estableciendo la contraseña en el archivo de configuración del programa (config.xml)"
sed -i -- "s/<password_base_datos></<password_base_datos>$PASS</g" /var/www/ViewOffice/etc/config.xml


log_msg echo ""
log_msg echo "Si la contraseña de root no está bien definida, puedes intentar dejarla en blanco ejecutando el comando:"
log_msg echo "mysqld_safe --init-file=./mysql_pass"

echo ""
log_msg echo ""
log_msg echo "Instalación finalizada."
